% Conduct the experiments on bivariate data in Subsection 4.1 
% using the proposed method, nCor, MI, and dCor.

clear all
close all

N = [200 500 1000 2000];
M = 50;

%%%%%%%
% R2 = 0.0;
% R2 = 0.4;
R2 = 0.8;
%%%%%%%


for i = 1:length(N)
    n = N(i);
    for j = 1:M
        display([i,j])
        e = randn(n,1);
        e = e/std(e);
        for cn = 1:3
            if cn == 1
                x = 2*rand(n,1)-1;
            elseif cn == 2
                x = randn(n,1);
            elseif cn == 3
                x = random('exp',1,n,1);
            end
            y = sin(pi*x(:,1));
            e1 = .3*e;
            e2 = .2*e.*(x(:,1)+1.1);
            e3 = .3*e.*cos(pi*x(:,1));
            e4 = .2*e.*(sign(cos(pi*x(:,1)))+1.5);

            y1 = R2^.5*y/std(y)+(1-R2)^.5*e1/std(e1);
            y2 = R2^.5*y/std(y)+(1-R2)^.5*e2/std(e2);
            y3 = R2^.5*y/std(y)+(1-R2)^.5*e3/std(e3);
            y4 = R2^.5*y/std(y)+(1-R2)^.5*e4/std(e4);

            [r1{1,cn}(i,j),r2{1,cn}(i,j)] = ncor2(x,y1);
            [r1{2,cn}(i,j),r2{2,cn}(i,j)] = ncor2(x,y2);
            [r1{3,cn}(i,j),r2{3,cn}(i,j)] = ncor2(x,y3);
            [r1{4,cn}(i,j),r2{4,cn}(i,j)] = ncor2(x,y4);
            
            addpath ./MIandDCOR
            aaa = corrcoef(x,y1);
            r3{1,cn}(i,j) = aaa(2)^2;
            r4{1,cn}(i,j) = 1-exp(-2*mutual_information(x',y1'));
            r5{1,cn}(i,j) = distcorr(x,y1);
            aaa = corrcoef(x,y2);
            r3{2,cn}(i,j) = aaa(2)^2;
            r4{2,cn}(i,j) = 1-exp(-2*mutual_information(x',y2'));
            r5{2,cn}(i,j) = distcorr(x,y2);
            aaa = corrcoef(x,y3);
            r3{3,cn}(i,j) = aaa(2)^2;
            r4{3,cn}(i,j) = 1-exp(-2*mutual_information(x',y3'));
            r5{3,cn}(i,j) = distcorr(x,y3);
            aaa = corrcoef(x,y4);
            r3{4,cn}(i,j) = aaa(2)^2;
            r4{4,cn}(i,j) = 1-exp(-2*mutual_information(x',y4'));
            r5{4,cn}(i,j) = distcorr(x,y4);
            rmpath ./MIandDCOR
            
            X{cn,i,j} = x;
            Y1{cn,i,j} = y1;
            Y2{cn,i,j} = y2;
            Y3{cn,i,j} = y3;
            Y4{cn,i,j} = y4;
        end
    end
end
